﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Xml.Linq;

namespace SWAT_Office_App
{
    class Stat_Logging
    {
        private static string logFileLocation = "StatLog.xml";
        public static int AccountsCreated { get; set; }
        public static int SharesCreated { get; set; }

        public static void ImportSettings()
        {
            try
            {
                if (File.Exists(logFileLocation))
                {
                    XElement Log = XElement.Load(logFileLocation);
                    AccountsCreated = int.Parse(Log.Element("AccountsCreated").Value);
                    SharesCreated = int.Parse(Log.Element("SharesCreated").Value);
                    Debug.appendText("Stats from " + logFileLocation + " has been imported");
                }
                else
                {
                    Debug.appendText("No existing stat logging file detected.");
                    WriteDefaultConfigFile();
                }
            }
            catch (Exception e)
            {
                //MessageBox.Show(e.ToString(), "Error");
                Debug.appendText(e.ToString());
                MessageBox.Show("An error has occured. Please notify a supervisor to debug.", "Error");
            }
        }
        public static void ExportSettings()
        {
            try
            {
                XElement Log = XElement.Load(logFileLocation);
                Log.SetElementValue("AccountsCreated", AccountsCreated);
                Log.SetElementValue("SharesCreated", SharesCreated);
                Log.Save(logFileLocation);
                Debug.appendText("Stats has been exported to " + logFileLocation);
            }
            catch (Exception e)
            {
                //MessageBox.Show(e.ToString(), "Error");
                Debug.appendText(e.ToString());
                MessageBox.Show("An error has occured. Please notify a supervisor to debug.", "Error");
            }
        }
        private static void WriteDefaultConfigFile()
        {
            try
            {
                XElement Log = new XElement("StatLog",
                    new XElement("AccountsCreated", 0),
                    new XElement("SharesCreated", 0)
                    );
                Log.Save(logFileLocation);
                Debug.appendText("A blank stat logging file has been created");
            }
            catch (Exception e)
            {
                //MessageBox.Show(e.ToString(), "Error");
                Debug.appendText(e.ToString());
                MessageBox.Show("An error has occured. Please notify a supervisor to debug.", "Error");
            }
        }
    }
}
